package com.ejie.ab04b.dao.custom;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.comun.UtilDAO;
import com.ejie.ab04b.model.OS2;
import com.ejie.ab04b.model.Tarea;
import com.ejie.ab04b.model.TareaOS2;
import com.ejie.ab04b.model.Tramite;
import com.ejie.ab04b.model.TramiteOS2;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * TareaOS2DaoImpl generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class TareaTramiteOS2CustomDaoImpl implements TareaTramiteOS2CustomDao {

	private static final String QUERY_SELECT = "SELECT t1.ID_TAREA_093 IDTAREA093, t1.MAILBOX_TASK_ID_093 MAILBOXTASKID093, t1.TIPO_TAREA_093 TIPOTAREA093, t1.ESTADO_093 ESTADO093, t1.FECHA_INI_093 FECHAINI093, t1.FECHA_FIN_093 FECHAFIN093, t1.USUARIO_093 USUARIO093, t1.ID_TRAMITE_093 IDTRAMITE093, t1.ID_TRAMITE_090 IDTRAMITE090, t1.TASK_ID_090 TASKID090, t1.DESCRIPCION_ES_090 DESCRIPCIONES090, t1.DESCRIPCION_EU_090 DESCRIPCIONEU090, t1.ES_INICIAL_090 ESINICIAL090, t1.TIPO_090 TIPO090, t1.ID_TRAMITE_092 IDTRAMITE092, t1.TIPO_TRAMITE_092 TIPOTRAMITE092, t1.TERRIT_OS2_092 TERRITOS2092, t1.ANO_OS2_092 ANOOS2092, t1.NUM_OS2_092 NUMOS2092, t1.PROCEDURE_ID_089 PROCEDUREID089, t1.PROCEEDING_ID_089 PROCEEDINGID089, t1.DESCRIPCION_ES_089 DESCRIPCIONES089, t1.DESCRIPCION_EU_089 DESCRIPCIONEU089 FROM VTAREAS_TRAMITES_OS2 t1 ";
	private static final String QUERY_SELECT2 = "SELECT t1.ID_TAREA_093 IDTAREA093, t1.MAILBOX_TASK_ID_093 MAILBOXTASKID093,t2.TASK_TYPE_ID_043 TASKTYPEID043, t1.TIPO_TAREA_093 TIPOTAREA093, t1.ESTADO_093 ESTADO093, t1.FECHA_INI_093 FECHAINI093, t1.FECHA_FIN_093 FECHAFIN093, t1.USUARIO_093 USUARIO093, t1.ID_TRAMITE_093 IDTRAMITE093, t1.ID_TRAMITE_090 IDTRAMITE090, t1.TASK_ID_090 TASKID090, t1.DESCRIPCION_ES_090 DESCRIPCIONES090, t1.DESCRIPCION_EU_090 DESCRIPCIONEU090, t1.ES_INICIAL_090 ESINICIAL090, t1.TIPO_090 TIPO090, t1.ID_TRAMITE_092 IDTRAMITE092, t1.TIPO_TRAMITE_092 TIPOTRAMITE092, t1.TERRIT_OS2_092 TERRITOS2092, t1.ANO_OS2_092 ANOOS2092, t1.NUM_OS2_092 NUMOS2092, t1.PROCEDURE_ID_089 PROCEDUREID089, t1.PROCEEDING_ID_089 PROCEEDINGID089, t1.DESCRIPCION_ES_089 DESCRIPCIONES089, t1.DESCRIPCION_EU_089 DESCRIPCIONEU089, t3.NOTAS_046 AS NOTAS046 FROM VTAREAS_TRAMITES_OS2 t1 ";

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TareaOS2> rwMap = new RowMapper<TareaOS2>() {
		public TareaOS2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TareaOS2 tarea = new TareaOS2(resultSet.getLong("IDTAREA093"),
					resultSet.getString("MAILBOXTASKID093"), null,
					resultSet.getLong("ESTADO093"),
					resultSet.getTimestamp("FECHAINI093"),
					resultSet.getTimestamp("FECHAFIN093"),
					resultSet.getString("USUARIO093"), new TramiteOS2(
							resultSet.getLong("IDTRAMITE093")));

			tarea.setTipoTarea(new Tarea(resultSet.getLong("TIPOTAREA093"),
					new Tramite(resultSet.getLong("IDTRAMITE090")), resultSet
							.getString("TASKID090"), resultSet
							.getString("DESCRIPCIONES090"), resultSet
							.getString("DESCRIPCIONEU090"), resultSet
							.getBoolean("ESINICIAL090"), resultSet
							.getString("TIPO090")));

			if (UtilDAO.hasColumn(resultSet, "TASKTYPEID043")) {
				if (resultSet.getString("TASKTYPEID043") != null) {
					tarea.setError(resultSet.getString("TASKTYPEID043"));
				}
			}

			// Notas asociadas a la tarea
			if (UtilDAO.hasColumn(resultSet, "NOTAS046")) {
				tarea.setNotas046(resultSet.getString("NOTAS046"));
			}

			TramiteOS2 tram = new TramiteOS2(resultSet.getLong("IDTRAMITE092"),
					null, null);

			tram.setos2(new OS2(resultSet.getString("TERRITOS2092"), resultSet
					.getString("ANOOS2092"), resultSet.getInt("NUMOS2092")));

			tram.setTipoTramite(new Tramite(
					resultSet.getLong("TIPOTRAMITE092"), resultSet
							.getString("PROCEDUREID089"), resultSet
							.getString("PROCEEDINGID089"), resultSet
							.getString("DESCRIPCIONES089"), resultSet
							.getString("DESCRIPCIONEU089")));

			tarea.setTramiteOS2(tram);

			return tarea;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the TareaOS2 table.
	 * 
	 * tareaOS2 TareaOS2 TareaOS2
	 * 
	 * @param tareaOS2
	 *            the tarea OS 2
	 * @return the tarea OS 2
	 */
	@Transactional(readOnly = true)
	public TareaOS2 vfind(TareaOS2 tareaOS2) {
		StringBuilder query = new StringBuilder(
				TareaTramiteOS2CustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TAREA_093 = ? ");

		List<TareaOS2> tareaOS2List = this.jdbcTemplate.query(query.toString(),
				this.rwMap, tareaOS2.getIdTarea093());
		return (TareaOS2) DataAccessUtils.uniqueResult(tareaOS2List);
	}

	/**
	 * Finds a list of rows in the TareaOS2 table.
	 * 
	 * tareaOS2 TareaOS2 jqGridRequestDto JQGridRequestDto List<TareaOS2>
	 * 
	 * @param tareaOS2
	 *            the tarea OS 2
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TareaOS2> vfindAll(TareaOS2 tareaOS2,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				TareaTramiteOS2CustomDaoImpl.QUERY_SELECT2);

		query.append(" LEFT JOIN AB0443T00 t2 on t1.MAILBOX_TASK_ID_093=t2.MAILBOX_TASK_ID_043 ");

		query.append(" LEFT JOIN AB0446T00 t3 on t3.ID_TAREA_046=t1.ID_TAREA_093 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tareaOS2);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" ORDER BY t1.FECHA_INI_093 DESC,t1.FECHA_FIN_093 DESC,T1.ESTADO_093 DESC");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TareaOS2>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TareaOS2 entity
	 * 
	 * tareaOS2 TareaOS2 Bean with the criteria values to filter by. Map created
	 * with two keys key query stores the sql query syntax key params stores the
	 * parameter values to be used in the condition sentence.
	 * 
	 * @param tareaOS2
	 *            the tarea OS 2
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TareaOS2 tareaOS2) {

		StringBuilder where = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		if (tareaOS2 != null && tareaOS2.getIdTarea093() != null) {
			where.append(" AND t1.ID_TAREA_093 = ?");
			params.add(tareaOS2.getIdTarea093());
		}
		if (tareaOS2 != null && tareaOS2.getTramiteOS2() != null
				&& tareaOS2.getTramiteOS2().getIdTramite092() != null) {
			where.append(" AND t1.ID_TRAMITE_093 = ?");
			params.add(tareaOS2.getTramiteOS2().getIdTramite092());
		}
		if (tareaOS2 != null && tareaOS2.getMailboxTaskId093() != null) {
			where.append(" AND t1.MAILBOX_TASK_ID_093 = ?");
			params.add(tareaOS2.getMailboxTaskId093());
		}
		if (tareaOS2 != null && tareaOS2.getEstado093() != null) {
			where.append(" AND t1.ESTADO_093 = ?");
			params.add(tareaOS2.getEstado093());
		}
		if (tareaOS2 != null && tareaOS2.getFechaIni093() != null) {
			where.append(" AND t1.FECHA_INI_093 = ?");
			params.add(tareaOS2.getFechaIni093());
		}
		if (tareaOS2 != null && tareaOS2.getFechaFin093() != null) {
			where.append(" AND t1.FECHA_FIN_093 = ?");
			params.add(tareaOS2.getFechaFin093());
		}
		if (tareaOS2 != null && tareaOS2.getUsuario093() != null) {
			where.append(" AND t1.USUARIO_093 = ?");
			params.add(tareaOS2.getUsuario093());
		}

		if (tareaOS2 != null && tareaOS2.getTipoTarea() != null
				&& tareaOS2.getTipoTarea().getIdTarea090() != null) {
			where.append(" AND t1.TIPO_TAREA_093 = ?");
			params.add(tareaOS2.getTipoTarea().getIdTarea090());
		}
		if (tareaOS2 != null
				&& tareaOS2.getTipoTarea() != null
				&& tareaOS2.getTipoTarea().getTramite() != null
				&& tareaOS2.getTipoTarea().getTramite().getIdTramite089() != null) {
			where.append(" AND t1.ID_TRAMITE_090 = ?");
			params.add(tareaOS2.getTipoTarea().getTramite().getIdTramite089());
		}
		if (tareaOS2 != null && tareaOS2.getTipoTarea() != null
				&& tareaOS2.getTipoTarea().getTaskId090() != null) {
			where.append(" AND t1.TASK_ID_090 = ?");
			params.add(tareaOS2.getTipoTarea().getTaskId090());
		}
		if (tareaOS2 != null && tareaOS2.getTipoTarea() != null
				&& tareaOS2.getTipoTarea().getDescripcionEs090() != null) {
			where.append(" AND t1.DESCRIPCION_ES_090 = ?");
			params.add(tareaOS2.getTipoTarea().getDescripcionEs090());
		}
		if (tareaOS2 != null && tareaOS2.getTipoTarea() != null
				&& tareaOS2.getTipoTarea().getDescripcionEu090() != null) {
			where.append(" AND t1.DESCRIPCION_EU_090 = ?");
			params.add(tareaOS2.getTipoTarea().getDescripcionEu090());
		}
		if (tareaOS2 != null && tareaOS2.getTipoTarea() != null
				&& tareaOS2.getTipoTarea().getEsInicial090() != null) {
			where.append(" AND t1.ES_INICIAL_090 = ?");
			params.add(tareaOS2.getTipoTarea().getEsInicial090());
		}
		if (tareaOS2 != null && tareaOS2.getTipoTarea() != null
				&& tareaOS2.getTipoTarea().getEsInicial090() != null) {
			where.append(" AND t1.TIPO_090 = ?");
			params.add(tareaOS2.getTipoTarea().getEsInicial090());
		}

		if (tareaOS2 != null && tareaOS2.getTramiteOS2() != null
				&& tareaOS2.getTramiteOS2().getos2() != null
				&& tareaOS2.getTramiteOS2().getos2().getTeros2060() != null) {
			where.append(" AND t1.TERRIT_OS2_092 = ?");
			params.add(tareaOS2.getTramiteOS2().getos2().getTeros2060());
		}
		if (tareaOS2 != null && tareaOS2.getTramiteOS2() != null
				&& tareaOS2.getTramiteOS2().getos2() != null
				&& tareaOS2.getTramiteOS2().getos2().getAnoos2060() != null) {
			where.append(" AND t1.ANO_OS2_092 = ?");
			params.add(tareaOS2.getTramiteOS2().getos2().getAnoos2060());
		}
		if (tareaOS2 != null && tareaOS2.getTramiteOS2() != null
				&& tareaOS2.getTramiteOS2().getos2() != null
				&& tareaOS2.getTramiteOS2().getos2().getNumos2060() != null) {
			where.append(" AND t1.NUM_OS2_092 = ?");
			params.add(tareaOS2.getTramiteOS2().getos2().getNumos2060());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

}
